"""
Markdown-Moin Extension
=======================

A collection of extensions which add some MoinMoin syntax to Python-Markdown
to use from inside MoinMoin.
These extensions must be called inside MoinMoin, and cannot run without it.

text_markdown plugin for MoinMoin is mandatory for this extension,
and we have to modify the plugin a bit to get the extension to work.

How to get this to work
-----------------------

We have to call the plugin from text_markdown plugin of MoinMoin.
See text_markdown.py for details.

Extensions included
-------------------

- moinlinks:
    Adds MoinMoin-styled link syntax.
    [[WikiLink]] or [[WikiLink | Description]] or [[attachment:foo.txt]] etc

    Similar to wikilinks extension in Python-Markdown package,
    but we use MoinMoin parser here, which enjoys different styles according to
    states of the link target (nonexistance, outbound, etc) and understands
    link descriptions and attachment linking.

- mointrans:
    Adds MoinMoin-styled embedding link syntax.
    {{WikiLink}} or {{attachment:foo.jpg}} etc

Copyright 2014 dossist.

"""


from markdown.extensions import Extension
from mdx_moinlinks import MoinLinksExtension
from mdx_mointrans import MoinTransExtension

class MoinExtension(Extension):
    def __init__(self, *args, **kwargs):
    	# save raw configs passed to the class for later uses
        self.args = args
        self.kwargs = kwargs
        # default config values
        self.config = {
            'request' : ['', 'MoinMoin request object, mandatory'],
        }
        super(MoinExtension, self).__init__(*args, **kwargs)

    def extendMarkdown(self, md, md_globals):
        MoinLinksExtension(*(self.args), **(self.kwargs)).extendMarkdown(md, md_globals)
        MoinTransExtension(*(self.args), **(self.kwargs)).extendMarkdown(md, md_globals)


def makeExtension(*args, **kwargs):
    return MoinExtension(*args, **kwargs)

