"""
    MoinMoin - Parser for Markdown

    Syntax:

        To use in a code block:

            {{{{#!text_markdown
            <add markdown text here>
            }}}}

        To use for an entire page:

            #format text_markdown
            <add markdown text here>

    @copyright: 2009 by Jason Fruit (JasonFruit at g mail dot com)
                Modified by rupi AT devlol DOT org
                2014 modified by dossist
    @license: GNU GPL, see http://www.gnu.org/licenses/gpl for details

"""

from markdown import markdown
import sys, os

sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), "markdownext"))

Dependencies = ['user']

class Parser:
    """
    A thin wrapper around a Python implementation
    (http://www.freewisdom.org/projects/python-markdown/) of John
    Gruber's Markdown (http://daringfireball.net/projects/markdown/)
    to make it suitable for use with MoinMoin.
    """

    extensions = ['.md']

    def __init__(self, raw, request, **kw):
        self.raw = raw
        self.request = request

        try:
            self.args = request.cfg.markdownargs
        except AttributeError:
            self.args = dict()
        if 'safe_mode' not in self.args:
            self.args['safe_mode'] = 'escape'

        # moin extension
        if 'extensions' not in self.args:
            self.args['extensions'] = []
        extensions = self.args['extensions']
        if 'mdx_moin' not in extensions:
            extensions.append('mdx_moin')

        if 'extension_configs' not in self.args:
            self.args['extension_configs'] = dict()
        ext_configs = self.args['extension_configs']
        ext_configs['mdx_moin'] = {'request': self.request}


    def format(self, formatter):
        output_html = markdown(self.raw, **self.args)
        try:
            self.request.write(formatter.rawHTML(output_html))
        except:
            self.request.write(formatter.escapedText(output_html))

